//
//  MCPDatabaseConnection+SourceListAdditions.h
//  MCFoundation
//
//  Created by Michael Clark on 05/10/04.
//  Copyright 2004 Marketcircle Inc. All rights reserved.
//

#import <Foundation/Foundation.h>
#import "MCPDatabaseConnection.h"

@protocol MCSourceList;

@interface MCPDatabaseConnection (SourceListAdditions)

- (BOOL)createWatchJoinsForWatchList: (id)aWatchList;
- (NSArray*)processWatchList: (id)aWatchList inContext: (id)aContext;

// Returns the count of matching objects for the given source list
- (NSNumber*)countForSourceList: (id <MCSourceList>)aSourceList;
- (NSNumber *)countForDumbList: (id)aSourceList;
- (NSNumber *)countForSmartList:(id)aSourceList; 

// Returns the count of objects which have not yet been linked to a watch list (no watch list join entry!)
- (NSNumber *)newCountForWatchList:(id)aWatchList; 
// Returns the count of objects in a watch list which have not been opened
- (NSNumber *)unseenCountForWatchList:(id)aWatchList; 


// Fetchs the objects which are new to the watch list
- (NSArray*)newObjectsForWatchList: (id)aWatchList;

@end
